%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% The credit derivatives market in general %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Visualize notional amount (in $trn) of outstanding CDS - data first needs to be imported manually.
visualize_cds_notional(cdsNotionalOutstanding, rowheaders, 1)
visualize_cds_notional(cdsNotionalOutstanding, rowheaders, 2)

%%%%%%%%%%%%%%%%%%%%%%%%%%
% Single name CDS prices %
%%%%%%%%%%%%%%%%%%%%%%%%%%

% Import Bloomberg data
cds_portfolio = import_cds_bloomberg('c:/thesis/data/bloomberg/cds series5.xls', swap_dates);

% Delete empty CDS
for j=length(cds_portfolio):(-1):1
    if (isempty(cds_portfolio(j).dates{1}))
        cds_portfolio = cds_portfolio([1:(j-1) (j+1):length(cds_portfolio)]);
    end
end

% Delete 'CMMC1U5' and 'CTOL1U5' because of partially missing data
for j=length(cds_portfolio):(-1):1
    if (ismember(cds_portfolio(j).company, {'CMMC1U5 Equity', 'CTOL1U5 Equity'}))
        cds_portfolio = cds_portfolio([1:(j-1) (j+1):length(cds_portfolio)]);
    end
end

% Import Markit data
CDX_NA_IG2 = import_cds_markit('c:/thesis/data/markit/cds data/');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Index and tranche price data %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Import historical tranche and index prices (Markit)
CDX_NA_IG2 = import_index_and_tranche_data_markit(CDX_NA_IG2);

% Import historical tranche and index prices (Bloomberg)
%[type, sheets] = xlsfinfo('../../data/CDX Tranche History.xls');
IG5Y_index = import_index_and_tranche_data('5Y IG', 4.75);
IG7Y_index = import_index_and_tranche_data('7Y IG', 6.75);
IG10Y_index = import_index_and_tranche_data('10Y IG', 9.75);

% Merge 5yr, 7yr, and 10yr data into single object
CDX_NA_IG = merge_maturities(IG5Y_index, IG7Y_index, IG10Y_index);

% % Merge CDS with index data
% CDX_NA_IG.portfolio = cds_portfolio;
% CDX_NA_IG.index_members = ones(length(CDX_NA_IG.dates{1}), length(CDX_NA_IG.portfolio));

% Import data from citi
CDX_NA_IG_citi = import_index_and_tranche_data_citi('c:/thesis/data/citi/Tranche-data X1.xls');

% Import CDS data from BarCap
CDX_NA_IG_barcap = import_cds_barcap('c:/thesis/data/barcap/HistoricalSpreads.xls');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Merge data from Citi, Markit, Morgan Stanley %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Impute data from Morgan Stanley into Markit data
CDX_NA_IG2 = merge_CDX_data(CDX_NA_IG2, CDX_NA_IG);

% Impute data from Citi into Markit data
CDX_NA_IG2 = merge_CDX_data_citi(CDX_NA_IG2, CDX_NA_IG_citi);

% Cap maturity at 5.25, 7.25 and 10.25 years
CDX_NA_IG2.T{1} = min(CDX_NA_IG2.T{1}, 5.25);
CDX_NA_IG2.T{2} = min(CDX_NA_IG2.T{2}, 7.25);
CDX_NA_IG2.T{3} = min(CDX_NA_IG2.T{3}, 10.25);

% Populate indicator matrix of index members
% [trash, series7_members] = xlsread('c:/thesis/data/markit/cdx_na_ig_s7 members.xls', 1, 'B2:B1000');
CDX_NA_IG2 = insert_index_members(CDX_NA_IG2);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Computstat data (short-term and long-term debt, number of shares, ...) %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Compustat data
tickers = {CDX_NA_IG2.portfolio.ticker}';
data_compustat = import_compustat('c:/thesis/data/compustat/stocks cdx.xls');
CDX_NA_IG2 = merge_CDX_covariates(CDX_NA_IG2, data_compustat);
clear data_compustat;

% Bloomberg stock price and market-cap data, DTD data
data_bloomberg = import_data_bloomberg();
% Call 'clean_data' in 'c:/thesis/mba slides/leandro code'
leandro_data_monthly2daily(data_bloomberg);
% Call 'get_DTD' in c:/thesis/mba slides/leandro code'
CDX_NA_IG2 = import_DTD(CDX_NA_IG2, data_bloomberg);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Convert data from daily to monthly frequency %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Only use data starting with CDX series 3
CDX_NA_IG2 = subperiod_cdx(CDX_NA_IG2, CDX_NA_IG2.dates{1}(1), CDX_NA_IG2.dates{1}(end));
CDX_NA_IG2_monthly = subperiod_cdx(CDX_NA_IG2, datenum('09/21/2004'), CDX_NA_IG2.dates{1}(end));
CDX_NA_IG2_monthly = convert_daily2monthly(CDX_NA_IG2_monthly);

%%%%%%%%%%%%%%%
% Swap Curves %
%%%%%%%%%%%%%%%

% Calculate quarterly discount functions for CDS pricing
[swap_curves, swap_dates, swap_maturities] = import_swap_curves();
%term_structure_cds = convert_swapcurves_termstructure(swap_curves, swap_maturities, swap_dates);
%discounts_cds = convert_zero_rates_discounts(term_structure_cds);
% Convert dates to numbers for computational efficiency
%discounts_cds.dates = datenum(discounts_cds.dates);

% Calculate non-standard maturity discount functions for index and tranche pricing
start = CDX_NA_IG2.T{1} - floor(CDX_NA_IG2.T{1}*4)/4;
start(start == 0) = 0.25;
T = zeros(length(start), 42);   % Use 10.5 years a maximum horizon, because non-business-day IMM dates can cause 10yr CDX have maturity > 10.25yrs
for i=1:length(start)
    T(i,1:42) = start(i) + (0:0.25:10.25);
end
term_structure_IMM = convert_swapcurves_termstructure2(swap_curves, swap_maturities, swap_dates, CDX_NA_IG2.dates{1}, T);
discounts_IMM = convert_zero_rates_discounts2(term_structure_IMM, T);

%%%%%%%%%%%%%%%%%%%%%%
% Macroeconomic data %
%%%%%%%%%%%%%%%%%%%%%%

% VIX Index
TS_VIX = import_VIX('c:/thesis/data/bloomberg/VIX.xls');
